/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.shadowmobs.entity;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupShadow;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackRanged;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowOwner;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerThreats;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.core.info.DropRate;
import com.lycanitesmobs.shadowmobs.entity.EntitySpectralbolt;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityPhantom
extends EntityCreatureTameable
implements IMob,
IGroupShadow {
    public EntityPhantom(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEAD;
        this.defense = 0;
        this.experience = 5;
        this.hasAttackSound = false;
        this.setWidth = 0.8f;
        this.setHeight = 1.2f;
        this.setupMob();
        this.field_70145_X = true;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackRanged(this).setSpeed(0.75).setRate(40).setRange(14.0f).setMinChaseDistance(0.75f).setCheckSight(false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowOwner(this).setStrayDistance(4.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetOwnerRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetOwnerAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class).setCheckSight(false));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class).setCheckSight(false));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetOwnerThreats(this));
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 15.0);
        baseAttributes.put("movementSpeed", 0.24);
        baseAttributes.put("knockbackResistance", 0.0);
        baseAttributes.put("followRange", 16.0);
        baseAttributes.put("attackDamage", 1.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(Items.field_151103_aS), 1.0f).setMaxAmount(5));
        this.drops.add(new DropRate(new ItemStack(Blocks.field_150343_Z), 0.5f).setMaxAmount(2));
        this.drops.add(new DropRate(new ItemStack((Block)Blocks.field_150465_bP, 1, 1), 0.25f).setMaxAmount(1));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getItem("SpectralboltCharge")), 0.25f).setMaxAmount(3));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_130014_f_().field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.func_130014_f_().func_175688_a(EnumParticleTypes.SPELL_WITCH, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    public void rangedAttack(Entity target, float range) {
        EntitySpectralbolt projectile = new EntitySpectralbolt(this.func_130014_f_(), (EntityLivingBase)this);
        projectile.setProjectileScale(0.5f);
        projectile.field_70163_u -= (double)(this.field_70131_O / 4.0f);
        float accuracy = 1.0f * (this.func_70681_au().nextFloat() - 0.5f);
        double d0 = target.field_70165_t - this.field_70165_t + (double)accuracy;
        double d1 = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f - projectile.field_70163_u + (double)accuracy;
        double d2 = target.field_70161_v - this.field_70161_v + (double)accuracy;
        float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
        float velocity = 1.2f;
        projectile.func_70186_c(d0, d1 + (double)f1, d2, velocity, 6.0f);
        this.func_184185_a(projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.func_130014_f_().func_72838_d((Entity)projectile);
        super.rangedAttack(target, range);
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean useDirectNavigator() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public boolean isDamageTypeApplicable(String type) {
        if (type.equals("inWall")) {
            return false;
        }
        return super.isDamageTypeApplicable(type);
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (potionEffect.func_188419_a() == MobEffects.field_76440_q) {
            return false;
        }
        if (ObjectManager.getPotionEffect("Fear") != null && potionEffect.func_188419_a() == ObjectManager.getPotionEffect("Fear")) {
            return false;
        }
        super.func_70687_e(potionEffect);
        return true;
    }

    @Override
    public boolean daylightBurns() {
        return !this.isTamed();
    }

    @Override
    protected SoundEvent func_184639_G() {
        if (this.hasAttackTarget() && this.func_70638_az() instanceof EntityPlayer && "Jbams".equals(((EntityPlayer)this.func_70638_az()).func_70005_c_())) {
            return AssetManager.getSound(this.mobInfo.name + "_say_jon");
        }
        if (this.isTamed() && this.func_70902_q() != null && "JBams".equals(this.getOwnerName())) {
            return AssetManager.getSound(this.mobInfo.name + "_say_jon");
        }
        return super.func_184639_G();
    }

    @Override
    public ResourceLocation getTexture() {
        if (!"Satan Claws".equals(this.func_95999_t())) {
            return super.getTexture();
        }
        String textureName = this.getTextureName() + "_satanclaws";
        if (AssetManager.getTexture(textureName) == null) {
            AssetManager.addTexture(textureName, this.group, "textures/entity/" + textureName.toLowerCase() + ".png");
        }
        return AssetManager.getTexture(textureName);
    }
}

